/*
 * Copyright (C) 1998  Junichi Satoh <junichi@astec.co.jp>
 *   All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 *	$Id: ioctl_wfd.h,v 1.1 1998/05/17 06:54:02 junichi Exp junichi $
 */

#ifndef	_MACHINE_IOCTL_WFD_H_
#define	_MACHINE_IOCTL_WFD_H_

#ifndef KERNEL
#include <sys/types.h>
#endif
#include <sys/ioccom.h>

#include <machine/ioctl_fd.h>

#define WFD_MAX_PASSWORD	32

struct wfd_protect {
	u_char protect_mode;
#define UNLOCK	0	/* Unlock */
#define WP	2	/* Write Protect */
#define PWP	3	/* Password Write Protect */
#define RWP	5	/* Read/Write Protect */
#define TUNLOCK	8	/* Temporary Unlock */
	u_char passwd_length;
	u_char passwd[WFD_MAX_PASSWORD + 1];
};

struct wfd_status {
	u_char		drive_type;
	u_char		medium_type;
	u_short		transfer_rate;
	u_short		sector_size;
	u_short		cyls;
	u_char		wp;
	u_char		heads;
	u_char		sectors;
	u_char		motor_delay;
	u_short		rpm;
	u_char		button_status;
	u_char		disk_status;
	u_char		prev_status;
	u_long		last_lba;
	u_long		bytes;
	u_short		space_s0;
	u_short		number_s0;
	u_short		space_s1;
	u_short		number_s1;
	unsigned	protect_mode;
	u_char		serial[40];
	u_char		field_format;
};

#define WFD_PROTECT	_IOW('F', 100, struct wfd_protect)
#define WFD_FORMAT	_IOW('F', 101, int)
#define WFD_STATUS	_IOR('F', 102, struct wfd_status)

#endif /* !_MACHINE_IOCTL_WFD_H_ */
